/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.inventory;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class FilteredSlot
extends class_1735 {
    private final Consumer<SlotChangedArgs> onItemChanged;
    private final int maxStackSize;
    private final int slot;
    private final Predicate<class_1799> mayPlacePredicate;

    public FilteredSlot(class_1263 container, int slot, int x, int y, int maxStackSize, Consumer<SlotChangedArgs> onItemChanged, Predicate<class_1799> mayPlacePredicate) {
        super(container, slot, x, y);
        Preconditions.checkArgument((maxStackSize > 0 && maxStackSize <= 64 ? 1 : 0) != 0, (Object)(maxStackSize + " is not valid. (1-64)"));
        this.slot = slot;
        this.maxStackSize = maxStackSize;
        this.onItemChanged = onItemChanged;
        this.mayPlacePredicate = mayPlacePredicate;
    }

    public int getSlotId() {
        return this.slot;
    }

    public int method_7675() {
        return Math.min(this.field_7871.method_5444(), this.maxStackSize);
    }

    public boolean method_7680(class_1799 stack) {
        return this.mayPlacePredicate.test(stack);
    }

    public void method_7673(class_1799 stack) {
        class_1799 oldStack = this.method_7677().method_7972();
        super.method_7673(stack);
        this.onItemChanged.accept(new SlotChangedArgs(this, oldStack, this.method_7677()));
    }

    @NotNull
    public class_1799 method_7671(int amount) {
        class_1799 oldStack = this.method_7677().method_7972();
        class_1799 removed = super.method_7671(amount);
        class_1799 newStack = this.method_7677();
        this.onItemChanged.accept(new SlotChangedArgs(this, oldStack, newStack));
        return removed;
    }

    public record SlotChangedArgs(FilteredSlot slot, class_1799 oldStack, class_1799 newStack) {
    }
}

